/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend;

import com.simibubi.create.foundation.render.TemplateBuffer;
import com.simibubi.create.foundation.render.backend.RenderWork;
import com.simibubi.create.foundation.render.backend.gl.GlBuffer;
import com.simibubi.create.foundation.render.backend.gl.attrib.VertexFormat;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public abstract class BufferedModel
extends TemplateBuffer {
    protected GlBuffer modelVBO;
    protected boolean removed;

    protected BufferedModel(BufferBuilder buf) {
        super(buf);
        if (this.vertexCount > 0) {
            this.init();
        }
    }

    protected void init() {
        this.modelVBO = new GlBuffer(34962);
        this.modelVBO.with(vbo -> this.initModel());
    }

    protected void initModel() {
        int stride = this.getModelFormat().getStride();
        int invariantSize = this.vertexCount * stride;
        GL15.glBufferData((int)34962, (long)invariantSize, (int)35044);
        this.modelVBO.map(invariantSize, buffer -> {
            for (int i = 0; i < this.vertexCount; ++i) {
                this.copyVertex((ByteBuffer)buffer, i);
            }
        });
    }

    protected abstract void copyVertex(ByteBuffer var1, int var2);

    protected abstract VertexFormat getModelFormat();

    protected int getTotalShaderAttributeCount() {
        return this.getModelFormat().getShaderAttributeCount();
    }

    public final void render() {
        if (this.vertexCount == 0 || this.removed) {
            return;
        }
        this.doRender();
    }

    protected abstract void doRender();

    protected void setupAttributes() {
        int numAttributes = this.getTotalShaderAttributeCount();
        for (int i = 0; i <= numAttributes; ++i) {
            GL20.glEnableVertexAttribArray((int)i);
        }
        this.getModelFormat().vertexAttribPointers(0);
    }

    public final void delete() {
        this.removed = true;
        if (this.vertexCount > 0) {
            RenderWork.enqueue(this::deleteInternal);
        }
    }

    protected void deleteInternal() {
        this.modelVBO.delete();
    }
}

