/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl.versioned;

import com.simibubi.create.foundation.render.backend.gl.versioned.DrawInstanced;
import com.simibubi.create.foundation.render.backend.gl.versioned.GlVersioned;
import com.simibubi.create.foundation.render.backend.gl.versioned.InstancedArrays;
import com.simibubi.create.foundation.render.backend.gl.versioned.MapBuffer;
import com.simibubi.create.foundation.render.backend.gl.versioned.RGPixelFormat;
import com.simibubi.create.foundation.render.backend.gl.versioned.VertexArrayObject;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Consumer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GlCompat {
    public final MapBuffer mapBuffer;
    public final VertexArrayObject vertexArrayObject;
    public final InstancedArrays instancedArrays;
    public final DrawInstanced drawInstanced;
    public final RGPixelFormat pixelFormat;

    public GlCompat(GLCapabilities caps) {
        this.mapBuffer = GlCompat.getLatest(MapBuffer.class, caps);
        this.vertexArrayObject = GlCompat.getLatest(VertexArrayObject.class, caps);
        this.instancedArrays = GlCompat.getLatest(InstancedArrays.class, caps);
        this.drawInstanced = GlCompat.getLatest(DrawInstanced.class, caps);
        this.pixelFormat = GlCompat.getLatest(RGPixelFormat.class, caps);
    }

    public void mapBuffer(int target, int offset, int length, Consumer<ByteBuffer> upload) {
        this.mapBuffer.mapBuffer(target, offset, length, upload);
    }

    public void vertexAttribDivisor(int index, int divisor) {
        this.instancedArrays.vertexAttribDivisor(index, divisor);
    }

    public void drawArraysInstanced(int mode, int first, int count, int primcount) {
        this.drawInstanced.drawArraysInstanced(mode, first, count, primcount);
    }

    public int genVertexArrays() {
        return this.vertexArrayObject.genVertexArrays();
    }

    public void deleteVertexArrays(int array) {
        this.vertexArrayObject.deleteVertexArrays(array);
    }

    public void bindVertexArray(int array) {
        this.vertexArrayObject.bindVertexArray(array);
    }

    public boolean vertexArrayObjectsSupported() {
        return this.vertexArrayObject != VertexArrayObject.UNSUPPORTED;
    }

    public boolean instancedArraysSupported() {
        return this.instancedArrays != InstancedArrays.UNSUPPORTED;
    }

    public boolean drawInstancedSupported() {
        return this.drawInstanced != DrawInstanced.UNSUPPORTED;
    }

    public static <V extends Enum<V>> V getLatest(Class<V> clazz, GLCapabilities caps) {
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        Enum last = constants[constants.length - 1];
        if (!((GlVersioned)((Object)last)).supported(caps)) {
            throw new IllegalStateException("");
        }
        return (V)Arrays.stream(constants).filter(it -> ((GlVersioned)((Object)it)).supported(caps)).findFirst().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeShaderSource(int glId, CharSequence source) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer sourceBuffer = MemoryUtil.memUTF8((CharSequence)source, (boolean)true);
            PointerBuffer pointers = stack.mallocPointer(1);
            pointers.put(sourceBuffer);
            GL20C.nglShaderSource((int)glId, (int)1, (long)pointers.address0(), (long)0L);
            APIUtil.apiArrayFree((long)pointers.address0(), (int)1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

