/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.instancing.util;

import com.simibubi.create.foundation.render.backend.instancing.InstanceData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import java.util.Optional;
import javax.annotation.Nullable;

public class ConditionalInstance<D extends InstanceData> {
    final InstancedModel<D> model;
    Condition condition;
    @Nullable
    private D instance;

    public ConditionalInstance(InstancedModel<D> model, Condition condition) {
        this.model = model;
        this.condition = condition;
        this.update();
    }

    public ConditionalInstance<D> setCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public ConditionalInstance<D> update() {
        boolean shouldShow = this.condition.shouldShow();
        if (shouldShow && this.instance == null) {
            this.instance = this.model.createInstance();
        } else if (!shouldShow && this.instance != null) {
            ((InstanceData)this.instance).delete();
            this.instance = null;
        }
        return this;
    }

    public Optional<D> get() {
        return Optional.ofNullable(this.instance);
    }

    public void delete() {
        if (this.instance != null) {
            ((InstanceData)this.instance).delete();
        }
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean shouldShow();
    }
}

