/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerSpeedProvider {
    static int clientTimer = 0;
    static int serverTimer = 0;
    static boolean initialized = false;
    static InterpolatedChasingValue modifier = new InterpolatedChasingValue().withSpeed(0.25f);

    public static void serverTick() {
        if (++serverTimer > ServerSpeedProvider.getSyncInterval()) {
            AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new Packet());
            serverTimer = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        if (Minecraft.func_71410_x().func_71356_B() && Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        modifier.tick();
        ++clientTimer;
    }

    public static Integer getSyncInterval() {
        return (Integer)AllConfigs.SERVER.tickrateSyncTimer.get();
    }

    public static float get() {
        return ServerSpeedProvider.modifier.value;
    }

    public static class Packet
    extends SimplePacketBase {
        public Packet() {
        }

        public Packet(PacketBuffer buffer) {
        }

        @Override
        public void write(PacketBuffer buffer) {
        }

        @Override
        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (!initialized) {
                    initialized = true;
                    clientTimer = 0;
                    return;
                }
                float target = (float)ServerSpeedProvider.getSyncInterval().intValue() / (float)Math.max(clientTimer, 1);
                modifier.target(Math.min(target, 1.0f));
                clientTimer = 0;
            });
            context.get().setPacketHandled(true);
        }
    }
}

